/**
* \file: message_recvr.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include "ipc/message_recvr.h"

#include "ipc/message_buffer.h"

// This value should fit for all messages received during normal operation. The cache is automatically extended if
// a message is received that is larger than the buffer size
#define DEFAULT_RECV_BUFFER_SIZE 512 //ensure selecting a value larger then sizeof(message_t)

//--------------------------------- public member definition ---------------------------------------------------------
message_buffer_t *message_recvr_create_receiver_buffer(void)
{
	return message_buffer_create_new(DEFAULT_RECV_BUFFER_SIZE);
}

void message_recvr_destroy_receiver_buffer(message_buffer_t *recvr_buffer)
{
	message_buffer_destroy(recvr_buffer);
}

error_code_t message_recvr_receive_msg(message_buffer_t *recvr_buffer, int a_socket)
{
	return message_buffer_receive(recvr_buffer,a_socket);
}

message_type_t message_recvr_get_msg_type(message_buffer_t *recvr_buffer)
{
	if (recvr_buffer==NULL)
		return __NO_MSG;
	return message_buffer_get_msg_type(recvr_buffer);
}

void message_recvr_get_msg_data(message_buffer_t *recvr_buffer, void **buf_ptr, size_t *buffer_size_ptr)
{
	if (recvr_buffer==NULL)
	{
		*buf_ptr=NULL;
		*buffer_size_ptr=0;
		return;
	}
	message_buffer_get_msg_data(recvr_buffer,buf_ptr,buffer_size_ptr);
}

const char *message_recvr_get_first_msg_string(message_buffer_t *recvr_buffer)
{
	if (recvr_buffer==NULL)
		return NULL;
	return message_buffer_get_first_msg_string(recvr_buffer);
}

const char *message_recvr_get_next_msg_string(message_buffer_t *recvr_buffer)
{
	if (recvr_buffer==NULL)
		return NULL;
	return message_buffer_get_next_msg_string(recvr_buffer);
}
//----------------------------------- private members definition -----------------------------------------------------
